#ifndef _HPP_BALLSY_BALL
#define _HPP_BALLSY_BALL

#include "gaia/gaia.hpp"
using namespace gaia;

#include "boost/signals2.hpp"

#include <deque>

class BallsyGame;
class PlayState;

struct BallSituation {
  Vector2 position;
  Vector2 movement;
  // spin?
};

class Ball {

  public:

    Ball(const BallsyGame *game, const PlayState *playState);
    virtual ~Ball();

    void OnStepPhysicsTime();
    void Draw(const Viewport &viewport, const Camera &camera) const;

    Vector2 GetPosition() const { return predictions.front().position; }
    Vector2 GetMovement() const { return predictions.front().movement; }

    const Vector2 &GetPredictedPosition(unsigned int time_ms) const;
    const Vector2 &GetPredictedMovement(unsigned int time_ms) const;

    void AddImpulse(const Vector2 &impulse, bool removeCurrentMovement = true);

    unsigned int GetPredictionDuration_ms() const { return predictionDuration_ms; }

    boost::signals2::signal<void()> sig_BallTouched;

  private:

    BallSituation IterateOnce(const BallSituation &currentSituation);
    void Recalculate(unsigned int startIndex, unsigned int endIndex);

    const BallsyGame *game;
    const PlayState *playState;

    Object *ballObject;
    Sprite *ballSprite;

    std::deque<BallSituation> predictions; // guaranteed to always be sized predictionSize
    unsigned int predictionSize;
    unsigned int predictionDuration_ms;

};

#endif
