#include "ballsyutils.hpp"

Vector2 GetPhysicsMovement(const Vector2 &currentMovement, const Vector2 &desiredMovement, float maxChangeMPS, unsigned int elapsedTime_ms) {
  Vector2 desiredDelta = desiredMovement - currentMovement;
  desiredDelta.NormalizeMax(maxChangeMPS * elapsedTime_ms * 0.001f);
  return currentMovement + desiredDelta;
}
