#include "aiplayercontroller.hpp"

#include "main.hpp"
#include "playstate.hpp"
#include "matchteam.hpp" // todo: should we know about team at all?
#include "playerbody.hpp"
#include "sequences.hpp"
#include "ball.hpp"

AIPlayerController::AIPlayerController(const BallsyGame *game, const PlayState *playState) : PlayerController(game, playState) {
}

AIPlayerController::~AIPlayerController() {
}

void AIPlayerController::OnStepPhysicsTime(PlayerBody *playerBody) {
  Vector2 multiplier = Vector2(0.7f, 0.9f); // depth / width of formation
  Vector2 offset = playState->GetBall()->GetPosition() * (Vector2(1, 1) - multiplier); // flow with ball pos
  offset += Vector2(playerBody->GetMatchTeam_tmphax()->GetSide(), 0) * 3; // offset towards own half
  Vector2 toTarget = playerBody->GetAbsoluteBasePosition() * multiplier + offset - playerBody->GetPosition();
  if (toTarget.GetLength() < 6.0f) toTarget *= toTarget.GetLength() / 6.0f;
  playerBody->SetDesiredMovement((toTarget * 4.0f).GetNormalizedMax(playState->GetFullVelocity()));
}

void AIPlayerController::EmptySequenceQueueHint(PlayerBody *playerBody) {
}
