#include "humanplayercontroller.hpp"

#include "defines.hpp"
#include "main.hpp"
#include "playstate.hpp"
#include "matchteam.hpp" // todo: should we know about team at all?
#include "playerbody.hpp"
//#include "sequences.hpp"
//#include "sequencelibrary.hpp"
#include "ball.hpp"

HumanPlayerController::HumanPlayerController(const BallsyGame *game, const PlayState *playState, const HumanGamer *humanGamer) : PlayerController(game, playState), humanGamer(humanGamer) {
  //createdSequence.sequence = 0;
}

HumanPlayerController::~HumanPlayerController() {
}

void QuantizeDirection(Vector2 &inputDirection, float bias) {

  // digitize input

  //inputDirection.Normalize(0);
  Vector2 inputDirectionNorm = inputDirection.GetNormalized(0);

  int directions = 8;//GetConfiguration()->GetInt("gameplay_quantizeddirectioncount", 8);

  radian angle = inputDirectionNorm.GetAngle();
  angle /= pi * 2.0f;
  angle = round(angle * directions);
  angle /= directions;
  angle *= pi * 2.0f;

  inputDirection = (inputDirectionNorm * (1.0 - bias) + (Vector2(1, 0).GetRotated(angle) * bias)).GetNormalized(inputDirectionNorm) * inputDirection.GetLength();
}

void HumanPlayerController::OnStepPhysicsTime(PlayerBody *playerBody) {

  /*
  unsigned long gameTime_ms = playState->GetGameTime_ms();
  int maximumAge_ms = 100;
  if (createdSequence.sequence && !createdSequence.inUse && gameTime_ms > createdSequence.creationTime_ms + maximumAge_ms) {
    delete createdSequence.sequence;
    createdSequence.sequence = 0;
  }
  */

  const KeyInput &keyInput = humanGamer->GetKeyInput();

  Vector2 inputDirection;
  float inputVelocity = 0;
  if (keyInput.left)  inputDirection.coords[0] -= 1.0f;
  if (keyInput.right) inputDirection.coords[0] += 1.0f;
  if (keyInput.up)    inputDirection.coords[1] -= 1.0f;
  if (keyInput.down)  inputDirection.coords[1] += 1.0f;
  inputDirection.Normalize(0);
  //QuantizeDirection(inputDirection, 1.0f);

  inputVelocity = (inputDirection.GetLength() > 0.5f) ? 1.0f : 0.0f;
  float veloMultiplier = playState->GetMediumVelocity();
  if (keyInput.actionkeys[2]) veloMultiplier = playState->GetFullVelocity();
  if (keyInput.actionkeys[8]) veloMultiplier = playState->GetSlowVelocity();
  inputVelocity *= veloMultiplier;

  Vector2 magnetDirection = inputDirection;
  float magnetVelocity = inputVelocity;
  //float ballDistance = playState->GetBall()->GetPredictedPosition(100).GetDistance(playerBody->GetPosition());
  //if (ballDistance < 5.0f) {
  if (playerBody == playerBody->GetMatchTeam_tmphax()->GetDesignatedPlayerBody()) {
    //int timeToBall_ms = playerBody->GetTimeNeededToGetToBall_ms();//GetTimeNeededForTravel_ms(true);
    //magnetDirection = (playState->GetBall()->GetPredictedPosition(timeToBall_ms) - playerBody->GetPosition()).GetNormalized(inputDirection);
    unsigned int timeToBall_ms = 0;
    Vector2 preferredBallPosition = GetPreferredBallPosition(playerBody, timeToBall_ms, inputDirection, inputVelocity);
    // todo: draw debug position thingy @ preferredBallPosition
    //printf("time to ball: %i\n", timeToBall_ms);
    magnetDirection = (preferredBallPosition - playerBody->GetPosition()).GetNormalized(inputDirection);
    //float ballDistance = playState->GetBall()->GetPredictedPosition(timeToBall_ms).GetDistance(playerBody->GetPosition());
    //magnetVelocity = Clamp(std::max(ballDistance * 7.5f, 5.0f), inputVelocity, playState->GetFullVelocity());
    //magnetVelocity = Clamp((ballDistance - playState->GetBallRadius()) * 7.5f, 0, playState->GetFullVelocity());
    //magnetVelocity = Clamp(ballDistance * 7.5f, 0, playState->GetFullVelocity());
    unsigned int timeNeeded_ms = playerBody->GetTimeNeededForTravel_ms(false, preferredBallPosition);
    if (timeNeeded_ms > 0) {
      Vector2 debugTextPos = playerBody->GetPosition() + Vector2(0, 1);//WorldToScreenVector(playerBody->GetPosition() + Vector2(0, 1), game->GetMainViewport(), playState->GetCamera());
      playState->DrawDebugText(patch::to_string(timeNeeded_ms) + " / " + patch::to_string(timeToBall_ms), debugTextPos);
      magnetVelocity = Clamp(((float)timeNeeded_ms / (float)timeToBall_ms) * playState->GetFullVelocity(), 0, playState->GetFullVelocity());
    } else magnetVelocity = 0;
    //magnetVelocity *= 1.0f - NormalizedClamp(playState->GetBall()->GetMovement().GetDistance(playerBody->GetMovement()), 5.0f, 15.0f);
  }

  playerBody->SetDesiredMovement(magnetDirection * magnetVelocity);


  if (!playerBody->HasActiveSequence()) {

    if (keyInput.actionkeys[1] || keyInput.actionkeys[4]) {
      PlayerBody *target = playerBody->GetMatchTeam_tmphax()->GetClosestPlayerBody(playerBody->GetPosition() + inputDirection * 15.0f);
      Vector2 toTarget = target->GetPosition() - playerBody->GetPosition();
      //if (keyInput.actionkeys[1]) toTarget += target->GetMovement() * 0.5f;
      if (keyInput.actionkeys[1]) toTarget.coords[0] += playerBody->GetMatchTeam_tmphax()->GetSide() * -4;
      Vector2 passDirection = (toTarget).GetNormalized(inputDirection);
      playerBody->RequestPassSequence(passDirection, toTarget.GetLength() * 1.6f);
      // const Sequence *passSequence = playState->GetSequenceLibrary()->Find(e_SequenceType_Pass);//FindPassSequence(playState->GetBall(), playerBody->GetPosition(), playerBody->GetMovement(), inputDirection * inputVelocity);
      // if (passSequence) playerBody->RequestSequence(passSequence);
      //if (!success) delete passSequence;
    }

    // relative: Vector2 targetDirectionRelative = inputDirection.GetRotated(-playerBody->GetAngle());
    playerBody->RequestDribbleSequence(inputDirection * inputVelocity);//sequenceLibrary->FindDribbleSequence(playState->GetBall(), playerBody->GetPosition(), playerBody->GetMovement(), inputDirection * inputVelocity);//playState->GetSequenceLibrary()->CreateSequence(e_SequenceType_Dribble, playerBody->GetMovement().GetLength(), targetDirectionRelative, inputVelocity);//sequenceLibrary->FindDribbleSequence(playState->GetBall(), playerBody->GetPosition(), playerBody->GetMovement(), inputDirection * inputVelocity);

/*
    if (createdSequence.sequence && createdSequence.inUse) {
      delete createdSequence.sequence;
      createdSequence.sequence = 0;
    }

    //const Sequence *dribbleSequence = playState->GetSequenceLibrary()->FindSequence(e_SequenceType_Dribble, playerBody->GetMovement().GetLength(), targetDirectionRelative, inputVelocity);//sequenceLibrary->FindDribbleSequence(playState->GetBall(), playerBody->GetPosition(), playerBody->GetMovement(), inputDirection * inputVelocity);
    if (!createdSequence.sequence) {
      Vector2 targetDirectionRelative = inputDirection.GetRotated(-playerBody->GetAngle());
      createdSequence.sequence = playState->GetSequenceLibrary()->CreateSequence(e_SequenceType_Dribble, playerBody->GetMovement().GetLength(), targetDirectionRelative, inputVelocity);//sequenceLibrary->FindDribbleSequence(playState->GetBall(), playerBody->GetPosition(), playerBody->GetMovement(), inputDirection * inputVelocity);
      createdSequence.creationTime_ms = gameTime_ms;
      createdSequence.inUse = false;
    }
    if (createdSequence.sequence) {
      createdSequence.inUse = playerBody->RequestSequence(createdSequence.sequence);
    }
*/

  }

}

void HumanPlayerController::EmptySequenceQueueHint(PlayerBody *playerBody) {
/*
  const KeyInput &keyInput = humanGamer->GetKeyInput();

  Vector2 inputDirection;
  float inputVelocity = 0;
  if (keyInput.left)  inputDirection.coords[0] -= 1.0f;
  if (keyInput.right) inputDirection.coords[0] += 1.0f;
  if (keyInput.up)    inputDirection.coords[1] -= 1.0f;
  if (keyInput.down)  inputDirection.coords[1] += 1.0f;
  inputDirection.Normalize(0);
  float veloMultiplier = 1.0f;
  if (keyInput.actionkeys[2]) veloMultiplier *= 1.5f;
  if (keyInput.actionkeys[8]) veloMultiplier *= 0.5f;
  inputVelocity = (inputDirection.GetLength() > 0.5f) ? 5.0f : 0.0f;
  inputVelocity *= veloMultiplier;

  playerBody->SequenceRequestQueue_Wipe();

  if (keyInput.actionkeys[4]) {
    PassSequence *passSequence = new PassSequence(playState->GetBall(), playerBody->GetPosition(), playerBody->GetMovement(), inputDirection * inputVelocity);
    playerBody->SequenceRequestQueue_Add(passSequence);
  }

  DribbleSequence *dribbleSequence = new DribbleSequence(playState->GetBall(), playerBody->GetPosition(), playerBody->GetMovement(), inputDirection * inputVelocity);
  playerBody->SequenceRequestQueue_Add(dribbleSequence);
*/
}

