#include "playercontroller.hpp"

#include "main.hpp"
#include "playstate.hpp"
#include "playerbody.hpp"
#include "ball.hpp"

PlayerController::PlayerController(const BallsyGame *game, const PlayState *playState) : game(game), playState(playState) {
}

PlayerController::~PlayerController() {
}

Vector2 PlayerController::GetPreferredBallPosition(const PlayerBody *playerBody, unsigned int &timeToBall_ms, const Vector2 &inputDirection, float inputVelocity) const {

  bool asap = false;

  if (asap) {
    // hasty version - get to ball as quickly as possible
    timeToBall_ms = playerBody->GetTimeNeededToGetToBall_ms();
    return playState->GetBall()->GetPredictedPosition(playerBody->GetTimeNeededToGetToBall_ms());
  }

  Vector2 targetPosition = playState->GetBall()->GetPredictedPosition(playState->GetBall()->GetPredictionDuration_ms());
  timeToBall_ms = playState->GetBall()->GetPredictionDuration_ms();

  float desiredMovementWeight = 1.0f;
  float perpendicularWeight = 1.0f;

  // for efficiency, defined here
  float desiredMovementRating = 0.0f;
  float perpendicularRating = 0.0f;
  float bestRating = -1.0f;

  unsigned int timeStep_ms = game->GetPhysicsTimeStep_ms() * 2;
  unsigned int maxTime_ms = playerBody->GetTimeNeededToGetToBall_ms() * 1.6f;
  if (_verbose()) playState->DrawDebugLine(playState->GetBall()->GetPredictedPosition(playerBody->GetTimeNeededToGetToBall_ms()), playState->GetBall()->GetPredictedPosition(maxTime_ms), 0.0f, 0.5f, 1.0f);
  for (unsigned int time_ms = playerBody->GetTimeNeededToGetToBall_ms(); time_ms < std::min(playState->GetBall()->GetPredictionDuration_ms(), maxTime_ms); time_ms += timeStep_ms) {

    Vector2 simBallPosition = playState->GetBall()->GetPredictedPosition(time_ms);
    Vector2 simToBall = simBallPosition - playerBody->GetPosition();
    Vector2 ballDirection = playState->GetBall()->GetPredictedMovement(time_ms).GetNormalized(0);

    desiredMovementRating = 1.0f + 1.0f * inputDirection.GetDotProduct(simToBall.GetNormalized(0));
    perpendicularRating = 1.0f - fabs(ballDirection.GetDotProduct(simToBall.GetNormalized(0)));

    float rating = desiredMovementRating * desiredMovementWeight +
                   perpendicularRating * perpendicularWeight;

    if (rating > bestRating) {
      bestRating = rating;

      timeToBall_ms = time_ms;
      targetPosition = simBallPosition;
    }
  }

  return targetPosition;

}
