#ifndef _HPP_BALLSY_PLAYERCONTROLLER
#define _HPP_BALLSY_PLAYERCONTROLLER

#include "gaia/gaia.hpp"
using namespace gaia;

class BallsyGame;
class PlayState;
class PlayerBody;

class PlayerController {

  public:

    PlayerController(const BallsyGame *game, const PlayState *playState);
    virtual ~PlayerController();

    virtual void OnStepPhysicsTime(PlayerBody *playerBody) = 0;

    virtual void EmptySequenceQueueHint(PlayerBody *playerBody) = 0;

  protected:

    Vector2 GetPreferredBallPosition(const PlayerBody *playerBody, unsigned int &timeToBall_ms, const Vector2 &inputDirection, float inputVelocity) const;

    const BallsyGame *game;
    const PlayState *playState;

  private:

};

#endif
