#ifndef _HPP_BALLSY_DEFINES
#define _HPP_BALLSY_DEFINES

#include "gaia/gaia.hpp"
using namespace gaia;

// class Spatial;
// class Object;

#include <deque>

struct KeyInput {
  KeyInput() {
    left = false;
    right = false;
    up = false;
    down = false;
    for (int i = 0; i < 9; i++) {
      actionkeys[i] = false;
    }
  }
  bool left;
  bool right;
  bool up;
  bool down;
  bool actionkeys[9];
};

struct SpatialSnapshot {
  unsigned long timestamp_ms;
  Spatial spatial;
};

struct ReplayObject {
  ReplayObject(const Object *object) {
    this->object = object;
  }
  std::deque<SpatialSnapshot> spatialSnapshots;
  //Spatial spatial;
  const Object *object;
};

struct ReplayLine {
  unsigned long timestamp_ms;
  Vector2 p1, p2;
  float r, g, b, alpha;
};

struct ReplayText {
  std::string text;
  Vector2 position;
  unsigned long timestamp_ms;
  unsigned int duration_ms;
};

/*
struct ObjectSnapshot {
  unsigned long timestamp_ms;
  std::vector<ReplayObject> replayObjects;
};
*/

#endif
