#ifndef _HPP_GAIA_LINE
#define _HPP_GAIA_LINE

#include <cmath>

#include "defines.hpp"

#include "vector2.hpp"

namespace gaia {

  class Line {

    public:
      Line();
      Line(const Vector2 vec1, const Vector2 vec2);
      virtual ~Line();

      virtual void SetVertex(unsigned char pos, const float x, const float y);
      virtual void SetVertex(unsigned char pos, const Vector2 &vec);
      virtual const Vector2 &GetVertex(unsigned char pos) const;
      //virtual const AABB GetAABB() const;
      virtual float GetDistanceToPoint(const Vector2 &point, float &u) const;
      virtual Vector2 GetIntersectionPoint(const Line &line) const;
      virtual Vector2 GetIntersectionPoint(const Line &line, float &u) const;
      virtual bool WhatSide(const Vector2 &point);
      virtual float GetLength() const { return (vertices[0] - vertices[1]).GetLength(); }

    protected:
      Vector2 vertices[2];

    private:

  };

}

#endif
