#include "main.hpp"

#include "playstate.hpp"
#include "replaystate.hpp"

bool _optimize() {
  return true;
}

bool _verbose() {
  return false;
}

BallsyGame::BallsyGame(int desiredGraphicsTimeStep_ms, int desiredPhysicsTimeStep_ms) : Game(desiredGraphicsTimeStep_ms, desiredPhysicsTimeStep_ms) {

  this->CreateFont(e_FontID_Debug, "res/fonts/unifont.ttf", 16);

  playState = new PlayState(this);
  replayState = new ReplayState(this, playState->GetReplayObjects(), playState->GetReplayLines(), playState->GetReplayTexts());

  ActivateState(playState);
}

BallsyGame::~BallsyGame() {

  DeactivateActiveState();

  delete playState;
  delete replayState;

  this->DeleteFont(e_FontID_Debug);
}

void BallsyGame::OnKeyDown(SDL_Keysym keysym) {
  switch (keysym.sym) {


    case SDLK_r:
      ActivateState(replayState);
      break;

    case SDLK_ESCAPE:
      ActivateState(playState);
      break;


    case SDLK_LEFT:
      keyInput.left = true;
      break;

    case SDLK_RIGHT:
      keyInput.right = true;
      break;

    case SDLK_UP:
      keyInput.up = true;
      break;

    case SDLK_DOWN:
      keyInput.down = true;
      break;


    case SDLK_q:
      keyInput.actionkeys[0] = true;
      break;

    case SDLK_w:
      keyInput.actionkeys[1] = true;
      break;

    case SDLK_e:
      keyInput.actionkeys[2] = true;
      break;

    case SDLK_a:
      keyInput.actionkeys[3] = true;
      break;

    case SDLK_s:
      keyInput.actionkeys[4] = true;
      break;

    case SDLK_d:
      keyInput.actionkeys[5] = true;
      break;

    case SDLK_z:
      keyInput.actionkeys[6] = true;
      break;

    case SDLK_x:
      keyInput.actionkeys[7] = true;
      break;

    case SDLK_c:
      keyInput.actionkeys[8] = true;
      break;


    default:
      break;

  }
}

void BallsyGame::OnKeyUp(SDL_Keysym keysym) {
  switch (keysym.sym) {

    case SDLK_LEFT:
      keyInput.left = false;
      break;

    case SDLK_RIGHT:
      keyInput.right = false;
      break;

    case SDLK_UP:
      keyInput.up = false;
      break;

    case SDLK_DOWN:
      keyInput.down = false;
      break;


    case SDLK_q:
      keyInput.actionkeys[0] = false;
      break;

    case SDLK_w:
      keyInput.actionkeys[1] = false;
      break;

    case SDLK_e:
      keyInput.actionkeys[2] = false;
      break;

    case SDLK_a:
      keyInput.actionkeys[3] = false;
      break;

    case SDLK_s:
      keyInput.actionkeys[4] = false;
      break;

    case SDLK_d:
      keyInput.actionkeys[5] = false;
      break;

    case SDLK_z:
      keyInput.actionkeys[6] = false;
      break;

    case SDLK_x:
      keyInput.actionkeys[7] = false;
      break;

    case SDLK_c:
      keyInput.actionkeys[8] = false;
      break;


    default:
      break;

  }
}

// void BallsyGame::OnStepPhysicsTime() {
//   if (GetActiveState() == playState) playState->SnapshotReplayObjects();
// }

int main(int argc, char *argv[]) {

  bool vsync = true;
  int w = 1280;
  int h = 720;
  if (argc > 2) {
    w = atoi(argv[1]);
    h = atoi(argv[2]);
  }
  Init(w, h, vsync, "BALLSY");

  int desiredGraphicsFPS = 120;
  int desiredGraphicsTimeStep_ms = 1000 / desiredGraphicsFPS;
  int physicsFPS = 200; // 200 is nice; it is high enough to not stutter too much from physics/graphics timestep difference, yet low enough to not slow down calculations. also, it will result in a 5ms timestep, which gives us the possibility to do stuff like time_ms % 10 for select updates (optimisation)
  int physicsTimeStep_ms = 1000 / physicsFPS;

  Game *ballsyGame = new BallsyGame(desiredGraphicsTimeStep_ms, physicsTimeStep_ms);
  ballsyGame->SetMaximizedViewport(1.777777f);

  ballsyGame->Run();

  delete ballsyGame;

  Exit();

  return 0;
}

namespace boost {
  void assertion_failed(char const * expr, char const * function, char const * file, long line) {
    //printf("%s @ line %li: %s %s\n", file, line, function, expr);

    char errorString[256];
    sprintf(errorString, "%s @ line %li: %s %s\n", file, line, function, expr);
    //blunted::Log(blunted::e_FatalError, "boost", "assertion_failed", errorString);
    //exit(1);
  }
}
