#ifndef _HPP_BALLSY_MAIN
#define _HPP_BALLSY_MAIN

#include "gaia/gaia.hpp"
using namespace gaia;

#include "defines.hpp"

class PlayState;
class ReplayState;

bool _optimize();
bool _verbose();

enum e_FontIDs {
  e_FontID_Debug = 1
};

class BallsyGame : public Game {

  public:

    BallsyGame(int desiredGraphicsTimeStep_ms = 10, int desiredPhysicsTimeStep_ms = 10);
    virtual ~BallsyGame();

    virtual void OnKeyDown(SDL_Keysym keysym);
    virtual void OnKeyUp(SDL_Keysym keysym);

    //virtual void OnStepPhysicsTime();

    const KeyInput &GetKeyInput() const { return keyInput; }

  private:

    PlayState *playState;
    ReplayState *replayState;

    KeyInput keyInput;

};

namespace boost {
  void assertion_failed(char const * expr, char const * function, char const * file, long line);
}

#endif
