#include "matchteam.hpp"

#include "ball.hpp"
#include "playstate.hpp"
#include "playerbody.hpp"
#include "sequences.hpp"

#include "controllers/aiplayercontroller.hpp"
#include "controllers/humanplayercontroller.hpp"

#include "main.hpp"

MatchTeam::MatchTeam(const BallsyGame *game, const PlayState *playState, Club *club, int id) : game(game), playState(playState), club(club), id(id) {
  printf("creating PlayerBodies from club %s\n", club->GetClubName().c_str());

  // std::vector<int> databasePlayerIDs;
  // club->GetPlayerSelection(11, databasePlayerIDs)

  //if (GetID() == 0) selectedPlayerID = 4; else selectedPlayerID = 100;

  playerNum = 5;

  for (unsigned int i = 0; i < playerNum; i++) {


    AIControlledPlayer aiControlledPlayer;

    aiControlledPlayer.player = new Player(club->GetDatabaseID());
    PlayerBody *playerBody = new PlayerBody(game, playState, this, i);
    aiControlledPlayer.player->AttachPlayerBody(playerBody);

    aiControlledPlayer.controller = new AIPlayerController(game, playState);

    playerAIControllerMapping.push_back(aiControlledPlayer);

    //PlayerBody* playerBody = new PlayerBody(game, playState, this, i);
    //PlayerBodies.push_back(PlayerBody);
  }
  UpdatePlayerBodyControllerMapping();

/*
  Vector2 test1(1, 0);
  test1.Print();
  printf("angle: %f\n", test1.GetAngle());
  Vector2 test2(-1, 0);
  test2.Print();
  printf("angle: %f\n", test2.GetAngle());
  Vector2 test3(0, 1);
  test3.Print();
  printf("angle: %f\n", test3.GetAngle());
  Vector2 test4(0, -1);
  test4.Print();
  printf("angle: %f\n", test4.GetAngle());
*/
}

MatchTeam::~MatchTeam() {

  UnregisterAllHumanGamers();

  printf("deleting the PlayerBodies from club %s\n", club->GetClubName().c_str());
  for (unsigned int i = 0; i < playerAIControllerMapping.size(); i++) {
    delete playerAIControllerMapping.at(i).controller;
    delete playerAIControllerMapping.at(i).player->GetPlayerBody();
    delete playerAIControllerMapping.at(i).player;
  }
  playerAIControllerMapping.clear();

}

void MatchTeam::OnStepPhysicsTime() {

  // preprocess players' physics
  for (unsigned int i = 0; i < playerBodyControllerMapping.size(); i++) { // todo: maybe switch direction every frame to stop team 1 from having first actions?
    playerBodyControllerMapping.at(i).playerBody->PreStepPhysicsTime();
  }

  //const KeyInput &keyInput = game->GetKeyInput();

  //if (GetID() == 0 && keyInput.actionkeys[0]) selectedPlayerID = int(floor(Random(0.0f, 4.99f)));
  for (unsigned int i = 0; i < humanGamersWithPlayerBody.size(); i++) {

    // autoswitch (todo; this is haxed in)
    PlayerBody *designatedPlayerBody = GetDesignatedPlayerBody();
    if (humanGamersWithPlayerBody.at(i).selectedPlayerBody != designatedPlayerBody) {
      humanGamersWithPlayerBody.at(i).selectedPlayerBody = designatedPlayerBody; // todo: make switching a function
      UpdatePlayerBodyControllerMapping();
    }

    const KeyInput &keyInput = humanGamersWithPlayerBody.at(i).humanGamer->GetKeyInput();

    //  switch player?
    if (keyInput.actionkeys[0]) {
      //humanGamersWithPlayer.at(i).selectedPlayerBody = GetPlayerBody(int(floor(Random(0.0f, playerNum - 0.01f)))); // todo: ehhh wut
      if (humanGamersWithPlayerBody.at(i).selectedPlayerBody != designatedPlayerBody) {
        humanGamersWithPlayerBody.at(i).selectedPlayerBody = GetDesignatedPlayerBody(); // todo: make switching a function
        UpdatePlayerBodyControllerMapping();
      }
    }

  }

  // control
  for (unsigned int i = 0; i < playerBodyControllerMapping.size(); i++) {
    playerBodyControllerMapping.at(i).controller->OnStepPhysicsTime(playerAIControllerMapping.at(i).player->GetPlayerBody());
  }

  // update players' physics
  for (unsigned int i = 0; i < playerBodyControllerMapping.size(); i++) { // todo: maybe switch direction every frame to stop team 1 from having first actions?
    playerBodyControllerMapping.at(i).playerBody->OnStepPhysicsTime();
  }

  // selection avatar
  for (unsigned int i = 0; i < humanGamersWithPlayerBody.size(); i++) {
    humanGamersWithPlayerBody.at(i).selectedPlayerObject->spatial.position = humanGamersWithPlayerBody.at(i).selectedPlayerBody->GetPosition();
    //humanGamersWithPlayerBody.at(i).selectedPlayerObject->spatial.orientation = humanGamersWithPlayerBody.at(i).selectedPlayerBody->GetAngle();
  }
}

void MatchTeam::Draw(const Viewport &viewport, const Camera &camera) const {
  for (unsigned int i = 0; i < playerAIControllerMapping.size(); i++) {
    playerAIControllerMapping.at(i).player->GetPlayerBody()->Draw(viewport, camera);
  }

  for (unsigned int i = 0; i < humanGamersWithPlayerBody.size(); i++) {
    humanGamersWithPlayerBody.at(i).selectedPlayerObject->Draw(viewport, camera);
  }
}

/*
PlayerBody *MatchTeam::GetPlayerBody(int id) const {
  return playerAIControllerMapping.at(id).PlayerBody;
}
*/

PlayerBody *MatchTeam::GetClosestPlayerBody(const Vector2 &searchPosition) const {

  float shortestDistance = 0;
  int shortestID = -1;
  for (unsigned int i = 0; i < playerBodyControllerMapping.size(); i++) {
    float distance = playerBodyControllerMapping.at(i).playerBody->GetPosition().GetDistance(searchPosition);
    if (distance < shortestDistance || shortestID == -1) {
      shortestDistance = distance;
      shortestID = i;
    }
  }

  assert(shortestID != -1);
  if (shortestID == -1) return 0; // should only happen when no match players exist

  return playerBodyControllerMapping.at((unsigned int)shortestID).playerBody;
}

PlayerBody *MatchTeam::GetDesignatedPlayerBody() const {

  // todo:
  // - calculate in timestep process instead, and cache

  // find player closest to ball
  float shortestTimeToBall = 0;
  int shortestID = -1;
  for (unsigned int i = 0; i < playerBodyControllerMapping.size(); i++) {
    unsigned int timeToBall = playerBodyControllerMapping.at(i).playerBody->GetTimeNeededToGetToBall_ms();//GetTimeNeededForTravel_ms(true);
    if (timeToBall < shortestTimeToBall || shortestID == -1) {
      shortestTimeToBall = timeToBall;
      shortestID = i;
    }
  }

  assert(shortestID != -1);
  if (shortestID == -1) return 0; // should only happen when no match players exist

  return playerBodyControllerMapping.at((unsigned int)shortestID).playerBody;
}

void MatchTeam::RegisterHumanGamer(const HumanGamer *humanGamer) {
  HumanGamerWithPlayerBody humanGamerWithPlayerBody;
  humanGamerWithPlayerBody.humanGamer = humanGamer;
  humanGamerWithPlayerBody.controller = new HumanPlayerController(game, playState, humanGamer);
  humanGamerWithPlayerBody.selectedPlayerBody = playerAIControllerMapping.at(playerNum - 1).player->GetPlayerBody();//GetPlayerBody(playerNum - 1);

  humanGamerWithPlayerBody.selectedPlayerSprite = new Sprite();
  humanGamerWithPlayerBody.selectedPlayerSprite->LoadFile("res/gfx/selection.png", e_FilterMode_Linear);
  humanGamerWithPlayerBody.selectedPlayerObject = new Object(&playState->GetWorldNode(), humanGamerWithPlayerBody.selectedPlayerSprite);
  humanGamerWithPlayerBody.selectedPlayerObject->spatial.z = 0.0f;
  humanGamerWithPlayerBody.selectedPlayerObject->spatial.scale = Vector2(1.0f, 1.0f);

  humanGamersWithPlayerBody.push_back(humanGamerWithPlayerBody);

  UpdatePlayerBodyControllerMapping();
}

void MatchTeam::UnregisterAllHumanGamers() {
  for (unsigned int i = 0; i < humanGamersWithPlayerBody.size(); i++) {
    delete humanGamersWithPlayerBody.at(i).controller;
    delete humanGamersWithPlayerBody.at(i).selectedPlayerObject;
    delete humanGamersWithPlayerBody.at(i).selectedPlayerSprite;
  }
  humanGamersWithPlayerBody.clear();
}

void MatchTeam::UpdatePlayerBodyControllerMapping() {

  playerBodyControllerMapping.clear();

  for (unsigned int i = 0; i < playerAIControllerMapping.size(); i++) {
    ControlledPlayerBody controlledPlayerBody;
    controlledPlayerBody.playerBody = playerAIControllerMapping.at(i).player->GetPlayerBody();
    controlledPlayerBody.controller = playerAIControllerMapping.at(i).controller;
    playerBodyControllerMapping.push_back(controlledPlayerBody);
  }

  for (unsigned int i = 0; i < humanGamersWithPlayerBody.size(); i++) {
    for (unsigned int j = 0; j < playerBodyControllerMapping.size(); j++) {
      if (playerBodyControllerMapping.at(j).playerBody == humanGamersWithPlayerBody.at(i).selectedPlayerBody) {
        playerBodyControllerMapping.at(j).controller = humanGamersWithPlayerBody.at(i).controller;
        break;
      }
    }
  }


}
