#ifndef _HPP_BALLSY_MATCHTEAM
#define _HPP_BALLSY_MATCHTEAM

#include "gaia/gaia.hpp"
using namespace gaia;

class BallsyGame;
class PlayState;
class Club;
class Player;
class PlayerBody;
class PlayerController;
class AIPlayerController;
class HumanPlayerController;
class HumanGamer;

struct HumanGamerWithPlayerBody {
  const HumanGamer *humanGamer;
  HumanPlayerController *controller;
  PlayerBody *selectedPlayerBody;
  Sprite *selectedPlayerSprite;
  Object *selectedPlayerObject;
};

struct AIControlledPlayer {
  Player *player;
  AIPlayerController *controller;
};

struct ControlledPlayerBody {
  PlayerBody *playerBody;
  PlayerController *controller;
};

class MatchTeam {

  public:

    MatchTeam(const BallsyGame *game, const PlayState *playState, Club *club, int id);
    virtual ~MatchTeam();

    void OnStepPhysicsTime();
    void Draw(const Viewport &viewport, const Camera &camera) const;

    unsigned int GetID() const { return id; }
    signed int GetSide() const { return id == 0 ? -1 : 1; }

    //PlayerBody *GetPlayerBody(int id) const;
    //ControlledPlayerBody *GetControlledPlayerBody(int id) const;
    PlayerBody *GetClosestPlayerBody(const Vector2 &searchPosition) const;
    PlayerBody *GetDesignatedPlayerBody() const;

    //void RegisterHumanPlayerController(HumanPlayerController *controller);
    void RegisterHumanGamer(const HumanGamer *humanGamer);
    void UnregisterAllHumanGamers();

  private:

    void UpdatePlayerBodyControllerMapping();

    const BallsyGame *game;
    const PlayState *playState;
    Club *club; // must be writable: setting injury states and such

    unsigned int id;

    unsigned int playerNum;

    std::vector<HumanGamerWithPlayerBody> humanGamersWithPlayerBody;

    // players with their persistent AI controllers
    std::vector<AIControlledPlayer> playerAIControllerMapping;

    // dynamic map with currently active controller per match player
    std::vector<ControlledPlayerBody> playerBodyControllerMapping;

};

#endif
