#ifndef _HPP_BALLSY_PLAYERBODY
#define _HPP_BALLSY_PLAYERBODY

#include "gaia/gaia.hpp"
using namespace gaia;

class BallsyGame;
class PlayState;
class MatchTeam;
class Sequence;
//class PlayerController;

struct MetaSequence {
  unsigned long startTime_ms;
  // relative: radian startAngle;
  const Sequence *sequence;
};

class PlayerBody {

  public:

    PlayerBody(const BallsyGame *game, const PlayState *playState, const MatchTeam *matchTeam, int id);
    virtual ~PlayerBody();

    void PreStepPhysicsTime();
    void OnStepPhysicsTime();
    void Draw(const Viewport &viewport, const Camera &camera) const;

    void UpdateSituation();

    Vector2 GetBasePosition() const;
    Vector2 GetAbsoluteBasePosition() const;

    unsigned int GetID() const { return id; }

    Vector2 GetPosition() const { return position; }
    Vector2 GetMovement() const { return movement; }//GetDirection() * GetVelocity(); }
    float GetVelocity() const { return movement.GetLength(); }//velocity; }
    Vector2 GetDirection() const { return movement.GetNormalized(0); }//Vector2(1, 0).GetRotated(GetAngle()); }
    radian GetAngle() const { return movement.GetAngle(); }//return angle; }
    radian GetBodyAngle() const { return bodyAngle; }

    void SetDesiredMovement(const Vector2 &desiredMovement) { this->desiredMovement = desiredMovement; }

    //void SequenceRequestQueue_Wipe();
    //void SequenceRequestQueue_Add(Sequence *sequence);
    //bool RequestSequence(const Sequence *sequence);
    bool RequestDribbleSequence(const Vector2 &ttargetMovement);
    bool RequestPassSequence(const Vector2 &targetDirection, float power);

    bool HasActiveSequence() const;

    const MatchTeam *GetMatchTeam_tmphax() const { return matchTeam; }

    unsigned int GetTimeNeededForTravel_ms(bool targetBall, const Vector2 &targetPosition = Vector2(0)) const;
    unsigned int GetTimeNeededToGetToBall_ms() const { return timeNeededToGetToBall_ms; }

  private:

    const BallsyGame *game;
    const PlayState *playState;
    const MatchTeam *matchTeam;

    unsigned int id;

    //PlayerController *playerController;

    Object *playerObject;
    Sprite *playerSprite;

    Object *nameObject;
    Sprite *nameSprite;

    Vector2 basePosition;

    Vector2 position;
    Vector2 movement;
    //float velocity;
    //radian angle;
    radian bodyAngle;

    Vector2 desiredMovement;
    //std::vector<Sequence*> sequenceRequestQueue;
    MetaSequence currentSequence;

    unsigned int timeNeededToGetToBall_ms;

};

#endif
