#ifndef _HPP_BALLSY_STATE_PLAY
#define _HPP_BALLSY_STATE_PLAY

#include "gaia/gaia.hpp"
using namespace gaia;

#include "defines.hpp"

#include <vector>

class BallsyGame;
class PlayState;
class Stadium;
class Ball;
class MatchTeam;
class PlayerBody;
class Club;
class Player;
class PlayerData;
class HumanGamer;
//class SequenceLibrary;

enum e_RunState {
  e_RunState_Running,
  e_RunState_Paused
};

class PlayState : public State {

  public:

    PlayState(BallsyGame *game);
    virtual ~PlayState();

    virtual void OnActivate();
    virtual void OnDeactivate();

    virtual void OnStepPhysicsTime();
    virtual void OnStepGraphicsTime();

    void DrawDebugLine(const Vector2 &p1, const Vector2 &p2, float r, float g, float b, float alpha = 1.0f) const;
    void DrawDebugText(const std::string &text, const Vector2 &position, int debugDuration_ms = -1) const;

    const SpatialNode &GetWorldNode() const { return worldNode; }
    const Camera &GetCamera() const { return camera; }

    Ball *GetBall() const { return ball; }
    const Stadium *GetStadium() const { return stadium; }

    void RegisterReplayObject(const Object *object) const { replayObjects.push_back(ReplayObject(object)); }
    std::vector<ReplayObject> &GetReplayObjects() const { return replayObjects; }
    void SnapshotReplayObjects();
    std::deque<ReplayLine> &GetReplayLines() const { return replayLines; }
    void CleanOutdatedReplayLines();
    std::deque<ReplayText> &GetReplayTexts() const { return replayTexts; }
    void CleanOutdatedReplayTexts();

    unsigned long GetGameTime_ms() const { return gameTime_ms; }

    //SequenceLibrary *GetSequenceLibrary() const;

    // 'globals'
    float GetFullVelocity() const { return 7.5f; }
    float GetMediumVelocity() const { return 5.0f; }
    float GetSlowVelocity() const { return 3.0f; }

    float GetBallRadius() const { return 0.25f; }
    float GetPlayerBodyRadius() const { return 0.5f; }

    unsigned int GetMaxReplayDuration_ms() const { return 5000; }

  private:

    Camera camera;
    SpatialNode worldNode;

    Object *hudObject;
    Sprite *hudSprite;

    Stadium *stadium;
    Ball *ball;

    Club *clubs[2];
    MatchTeam *matchTeams[2];
    //SequenceLibrary *sequenceLibrary;
    HumanGamer *bazkie;

    unsigned long gameTime_ms;
    e_RunState runState;

    std::deque<Vector2> camPosHistory;

    mutable std::vector<ReplayObject> replayObjects;
    mutable std::deque<ReplayLine> replayLines;
    mutable std::deque<ReplayText> replayTexts;

};

class HumanGamer {

  public:

    HumanGamer(const BallsyGame *game);
    virtual ~HumanGamer();

    const KeyInput &GetKeyInput() const;

  private:

    const BallsyGame *game;

};

/*
class Match {

  public:

    Match(const Club *club1, const Club *club2) : clubs[0](club1), clubs[1](club2) {};
    virtual ~Match() {};

    Match::CreateMatch() {
      matchTeams[0] = clubs[0]->CreateMatchTeam();
      matchTeams[1] = clubs[0]->CreateMatchTeam();
    }

  private:
    const Club *clubs[2];
    MatchTeam *matchTeams[2]; // match owns matchteams

};
*/

class Club {

  public:

    Club(int databaseID);
    virtual ~Club();

    std::string GetClubName() const { return clubName; }
    int GetDatabaseID() const { return databaseID; }
    //void GetPlayerSelection(int amount, std::vector<int> databasePlayerIDs)
    //MatchTeam *CreateMatchTeam(const Game *game, const State *state);

  private:

    int databaseID;
    std::string clubName;

    //std::vector<Player*> players;

};

class Player {

  public:

    Player(int databaseID);
    virtual ~Player();

    PlayerData *GetPlayerData() const;
    PlayerBody *GetPlayerBody() const;

    void AttachPlayerBody(PlayerBody *playerBody);
    void DetachPlayerBody();

  private:

    PlayerData *playerData;
    PlayerBody *playerBody;

};

class PlayerData {

  public:

    PlayerData(int databaseID);
    virtual ~PlayerData();

    std::string GetLastName() const { return lastName; }

  private:

    int databaseClubID;
    int databaseID;
    std::string lastName;

};

class Stadium {

  public:

    Stadium(const BallsyGame *game, const PlayState *playState);
    virtual ~Stadium();
    //std::vector<Object*> GetReplayObjects();

    //void OnStepGraphicsTime();
    void Draw(const Viewport &viewport, const Camera &camera) const;

    Vector2 GetPitchDimensions() const { return pitchDimensions; }

  private:

    const BallsyGame *game;
    const PlayState *playState;

    Vector2 pitchDimensions;

    Object *pitchObject;
    Sprite *pitchSprite;
    Object *pitchGlassObject;
    Sprite *pitchGlassSprite;

};

#endif
