#ifndef _HPP_BALLSY_STATE_REPLAY
#define _HPP_BALLSY_STATE_REPLAY

#include "gaia/gaia.hpp"
using namespace gaia;

#include "defines.hpp"

class BallsyGame;

class ReplayState : public State {

  public:

    ReplayState(BallsyGame *game, const std::vector<ReplayObject> &replayObjects, const std::deque<ReplayLine> &replayLines, const std::deque<ReplayText> &replayTexts);
    virtual ~ReplayState();

    virtual void OnActivate();
    virtual void OnDeactivate();

    virtual void OnStepPhysicsTime();
    virtual void OnStepGraphicsTime();

    unsigned long FindEarliestReplayObjectTimestamp_ms();
    //void SetReplayObjects(const std::vector<ReplayObject> &replayObjects);

    const SpatialNode &GetWorldNode() const { return worldNode; }
    const Camera &GetCamera() const { return camera; }

  private:

    Camera camera;
    SpatialNode worldNode;

    unsigned long replayTime_ms;

    std::deque<Vector2> camPosHistory;

    const std::vector<ReplayObject> &replayObjects;
    const std::deque<ReplayLine> &replayLines;
    const std::deque<ReplayText> &replayTexts;

};

#endif
