#ifndef __BALLSY_SEQUENCES
#define __BALLSY_SEQUENCES

#include "gaia/gaia.hpp"
using namespace gaia;

class BallsyGame;
class Ball;
class PlayerBody;


// SEQUENCE EVENTS

enum e_SequenceEventType {
  e_SequenceEventType_BallImpulse,
  e_SequenceEventType_PlayerBump
};

class SequenceEvent {

  public:

    SequenceEvent(e_SequenceEventType type) : type(type) {};
    virtual ~SequenceEvent() {};

    virtual bool TestIfLegal(unsigned int futureTime_ms) const = 0;
    virtual void Execute() = 0;

  protected:

    e_SequenceEventType type;

  private:

};

class BallImpulseSequenceEvent : public SequenceEvent {

  public:

    BallImpulseSequenceEvent(Ball *ball, const Vector2 &expectedBallPosition, float maxBallPositionDeviationRadius, const Vector2 &impulse);
    virtual ~BallImpulseSequenceEvent();

    virtual bool TestIfLegal(unsigned int futureTime_ms) const;
    virtual void Execute();

  private:

    Ball *ball;
    Vector2 expectedBallPosition;
    float maxBallPositionDeviationRadius;
    Vector2 impulse;

};


// SEQUENCES

enum e_SequenceType {
  e_SequenceType_Movement,
  e_SequenceType_Dribble,
  e_SequenceType_Pass,
  e_SequenceType_Shot
};

struct SequenceEventMeta {
  SequenceEventMeta() {
    done = false;
  }
  bool done;
  unsigned long triggerTime_ms;
  SequenceEvent *sequenceEvent;
};

void GeneratePhysicsMovement(std::vector<Vector2> &positions, const Game *game, unsigned int duration, const Vector2 &startPosition, const Vector2 &incomingMovement, const Vector2 &outgoingMovement, float curve, float exp);

class Sequence {

  public:

    Sequence(const BallsyGame *game, e_SequenceType type, const Vector2 &incomingMovement) : game(game), type(type), incomingMovement(incomingMovement) {};
    virtual ~Sequence() {};

    e_SequenceType GetType() const { return type; }

    //virtual bool TestIfLegal() const = 0;

    //virtual Vector2 GetPosition(unsigned int time_ms) const = 0;
    Vector2 GetPosition(unsigned int time_ms) const;
    Vector2 GetMovement(unsigned int time_ms) const;
    //virtual Vector2 GetMovement(unsigned int time_ms) const = 0;
    virtual unsigned int GetDuration_ms() const { return 0; }// const = 0;

    Vector2 GetStartPosition() const { assert(!positions.empty()); return positions.at(0); }
    Vector2 GetIncomingMovement() const { return incomingMovement; }
    float GetIncomingVelocity() const { return incomingMovement.GetLength(); }
    Vector2 GetOutgoingMovement() const;
    float GetOutgoingVelocity() const { return GetOutgoingMovement().GetLength(); }

    void ProcessEvents(unsigned int time_ms) const;

  private:

    const BallsyGame *game;

  protected:

    e_SequenceType type;
    std::vector<SequenceEventMeta> events;

    Vector2 incomingMovement;

    std::vector<Vector2> positions;

};

/*
class MovementSequence : public Sequence {

  public:

    MovementSequence(const BallsyGame *game, const Vector2 &test);
    virtual ~MovementSequence();

    virtual bool TestIfLegal() const;

    virtual Vector2 GetMovement(unsigned int time_ms) const;
    virtual unsigned int GetDuration_ms() const;

  private:

    Vector2 test;

};
*/

class DribbleSequence : public Sequence {

  public:

    DribbleSequence(const BallsyGame *game, const PlayerBody *playerBody, Ball *ball, const Vector2 &desiredMovement);
    virtual ~DribbleSequence();

    //virtual bool TestIfLegal() const;

    //virtual Vector2 GetPosition(unsigned int time_ms) const;
    //virtual Vector2 GetMovement(unsigned int time_ms) const;
    virtual unsigned int GetDuration_ms() const;

    static Vector2 GetPreferredBallPosition(const PlayerBody *playerBody);
    static bool IsBallTouchable(const PlayerBody *playerBody, const Ball *ball);
    static float maxBallPositionTouchRadius;
    static float touchTime_ms;
    static float maxBallPositionDeviationRadius;

  private:


};


class PassSequence : public Sequence {

  public:

    PassSequence(const BallsyGame *game, const PlayerBody *playerBody, Ball *ball, const Vector2 &targetDirection, float power);
    virtual ~PassSequence();

    //virtual bool TestIfLegal() const;

    //virtual Vector2 GetPosition(unsigned int time_ms) const;
    //virtual Vector2 GetMovement(unsigned int time_ms) const;
    virtual unsigned int GetDuration_ms() const;

    static Vector2 GetPreferredBallPosition(const PlayerBody *playerBody);
    static bool IsBallTouchable(const PlayerBody *playerBody, const Ball *ball);
    static float maxBallPositionTouchRadius;
    static float touchTime_ms;
    static float maxBallPositionDeviationRadius;

  private:


};


#endif
